#include <vpptype.h>
#include <cvidef.h>

/*== INTERFACE 9714 - bp9714 Include File ======================*/

/*== defines for serial communication =========================*/
#define NUL      0x00
#define STX      0x02
#define ETX      0x03
#define EOT      0x04
#define ENQ      0x05
#define ACK      0x06
#define CR       0x0D
#define NAK      0x15

/*== defines for program=======================================*/

#define  bp9714_RS232       1
#define  bp9714_RS48X       2

#define  bp9714_MAX_INSTR   100
#define  bp9714_MAX_CMD     256


#define  bp9714_VOLTAGE_ERROR     (1<<0)/* Bit 0 of Questionable Condition Register*/
#define  bp9714_CURRENT_ERROR     (1<<1)/* Bit 1 of Questionable Condition Register*/

#define  bp9714_DEVICE_DEPT_ERROR (1<<3)/* Bit 3 of Standard Event Register*/
#define  bp9714_EXECUTION_ERROR   (1<<4)/* Bit 4 of Standard Event Register*/

#define  bp9714_DEVICE_CALIBRATION (1<<0)/* Bit 0 of Operation Status Register*/
#define  bp9714_DEVICE_MEASURING  (1<<4)/* Bit 4 of Operation Status Register*/
#define  bp9714_DEVICE_EOC        (1<<8)/* Bit 8 of Operation Status Register*/
#define  bp9714_DEVICE_TARE        (1<<9)/* Bit 9 of Operation Status Register*/
#define  bp9714_RS485_CTRL_RTS 0          /* used in CVI only*/
#define  bp9714_RS485_CTRL_DTR 1
#define  bp9714_RS485_CTRL_LOWACTIVE 0
#define  bp9714_RS485_CTRL_HIGHACTIVE 1

/*== GLOBAL FUNCTION DECLARATIONS =========================================*/

int _VI_FUNC bp9714_init_device (int COMPort, int baudRate, double timeout_seconds,
                        int blockCheck, int groupAddress, int userAddress,
                        char instrumentIDString[], int resetDevice,
                        int *instrumentID);
int _VI_FUNC bp9714_init_all_devices (int COMPort, int baudRate, double timeout_seconds,
                             int blockCheck, int instrumentID[],
                             int groupAddresses[], int userAddresses[],
                             int *instrNumbers);
int _VI_FUNC bp9714_init_rs485 (int RS485CtrlBit, int ctrlBitState);
int _VI_FUNC bp9714_cal_state (int instrumentID, int state);
int _VI_FUNC bp9714_read_cal_state (int instrumentID, int *state);
int _VI_FUNC bp9714_cal_set_unit (int instrumentID, int calibrationUnit);
int _VI_FUNC bp9714_read_cal_unit (int instrumentID, int *calibrationUnit);
int _VI_FUNC bp9714_cal_input (int instrumentID, double lowCalValue, double highCalValue,
                      double lowScaleValue, double highScaleValue);
int _VI_FUNC bp9714_read_cal_input (int instrumentID, double *lowCalValue,
                           double *highCalValue, double *lowScaleValue,
                           double *highScaleValue);
int _VI_FUNC bp9714_cal_analogue_output (int instrumentID, double lowValue, double low_Scale,
                                double highValue, double high_Scale);
int _VI_FUNC bp9714_read_cal_analogue_output (int instrumentID, double *lowValue,
                                     double *low_Scale, double *highValue,
                                     double *high_Scale);
int _VI_FUNC bp9714_cal_input_meas (int instrumentID, int measure);
int _VI_FUNC bp9714_read_cal_input_meas (int instrumentID, double *kal1, double *kal2);
int _VI_FUNC bp9714_cal_accept_datas (int instrumentID);
int _VI_FUNC bp9714_config (int instrumentID, int averageControl, int averageCounts,
                   int measurementMode, int displayFormat, int deviceUnit,
                   int startMode);
int _VI_FUNC bp9714_read_config (int instrumentID, int *averageControl, int *averageCounts,
                        int *measurementMode, int *displayFormat, int *deviceUnit,
                        int *start_mode);
int _VI_FUNC bp9714_config_output (int instrumentID, int outputShape, int outputSupply);
int _VI_FUNC bp9714_read_config_output (int instrumentID, int *outputShape,
                               int *outputSupply);
int _VI_FUNC bp9714_config_analog_output (int instrumentID, int analogOutputType);
int _VI_FUNC bp9714_read_config_analog_output (int instrumentID, int *analogOutputType);
int _VI_FUNC bp9714_config_input (int instrumentID, int referencePoint, int inputFilter,
                         int voltageRange);
int _VI_FUNC bp9714_read_config_input (int instrumentID, int *referencePoint,
                              int *inputFilter, int *voltageRange);
int _VI_FUNC bp9714_comp_state (int instrumentID, int state);
int _VI_FUNC bp9714_read_comp_state (int instrumentID, int *state);
int _VI_FUNC bp9714_read_comp_count (int instrumentID, int *count);
int _VI_FUNC bp9714_comp_config (int instrumentID, int comparatorType,
                        int comparatorControl);
int _VI_FUNC bp9714_read_comp_config (int instrumentID, int *comparatorType,
                             int *comparatorControl);
int _VI_FUNC bp9714_comp_two_limit (int instrumentID, double lowerLimit, double upperLimit);
int _VI_FUNC bp9714_read_comp_two_limit (int instrumentID, double *lowerLimit,
                                double *upperLimit);
int _VI_FUNC bp9714_comp_four_limit (int instrumentID, double lowerLimit1,
                            double lowerLimit2, double upperLimit1,
                            double upperLimit2);
int _VI_FUNC bp9714_read_comp_four_limit (int instrumentID, double *lowerLimit1,
                                 double *lowerLimit2, double *upperLimit1,
                                 double *upperLimit2);
int _VI_FUNC bp9714_peak_detection_state (int instrumentID, int state);
int _VI_FUNC bp9714_read_peak_detection_state (int instrumentID, int *state);
int _VI_FUNC bp9714_read_peak_values (int instrumentID, double *minValue, double *maxValue,
                             double *diffValue);
int _VI_FUNC bp9714_tare_state (int instrumentID, int state);
int _VI_FUNC bp9714_read_tare_state (int instrumentID, int *state);
int _VI_FUNC bp9714_read_tare_value (int instrumentID, double *tareValue);
int _VI_FUNC bp9714_start_measure (int instrumentID);
int _VI_FUNC bp9714_read_measure (int instrumentID, double *value, char unit[],
                         char comparatorValue[]);
int _VI_FUNC bp9714_read_string_measure (int instrumentID, char *value,
                                char *comp_value);
int _VI_FUNC bp9714_stop_measure (int instrumentID);
int _VI_FUNC bp9714_system_serial_set_para (int instrumentID, int interfaceType,
                                   int groupAddress, int userAddress, int baudrate,
                                   int DBitsParitySBits, int parity, int blockCheck,
                                   int charDelay);
int _VI_FUNC bp9714_read_system_serial_para (int instrumentID, int *interfaceType,
                                    int *groupAddress, int *userAddress,
                                    int *baudrate, int *DBitsParitySBits,
                                    int *parity, int *blockCheck, int *charDelay);
int _VI_FUNC bp9714_system_serial_accept (int instrumentID);
int _VI_FUNC bp9714_store_memory (int instrumentID, int memoryNo);
int _VI_FUNC bp9714_get_status (int instrumentID);
int _VI_FUNC bp9714_recall_memory (int instrumentID, int memoryNo);
int _VI_FUNC bp9714_set_display_contrast (int instrumentID, double contrast);
int _VI_FUNC bp9714_read_display_contrast (int instrumentID, double *contrast);
int _VI_FUNC bp9714_system_error (int instrumentID, char systemError[]);
int _VI_FUNC bp9714_system_keyboard (int instrumentID, int keyboard);
int _VI_FUNC bp9714_system_security (int instrumentID, int code);
int _VI_FUNC bp9714_read_system_security (int instrumentID, int *code);
int _VI_FUNC bp9714_send_scpi (int instrumentID, char sendSCPIMessage[]);
int _VI_FUNC bp9714_receive_scpi (int instrumentID, char sendSCPIMessage[],
                         char instrumentAnswers[]);
int _VI_FUNC bp9714_logg_state (int instrumentID, int datenlogger);
int _VI_FUNC bp9714_read_logg_state (int instrumentID, int *data_logger_state);
int _VI_FUNC bp9714_clear_block (int instrumentID, int block);
int _VI_FUNC bp9714_select_block (int instrumentID, int block);
int _VI_FUNC bp9714_read_selected_block (int instrumentID, int *selectedBlock);
int _VI_FUNC bp9714_read_count (int instrument_ID, int *count, int block);
int _VI_FUNC bp9714_read_data (int instrumentID, int block, int number, float *value);
int _VI_FUNC bp9714_set_block_parameter (int instrumentID, int block, int size, char name[],
                                int filter, int XVal, double time, double delta);
int _VI_FUNC bp9714_read_block_parameter (int instrumentID, int *size, int block,
                                 char name[], int *filter, int *XVal, double *time,
                                 double *delta);
int _VI_FUNC bp9714_read_eval (int instrumentID, int block, double *minimum,
                      double *stdDeviation, double *maximum, double *meanValue);
int _VI_FUNC bp9714_read_data_block (int instrumentID, int block, int adresse, float data[]);
int _VI_FUNC bp9714_close (int instrumentID);

;/*=============================== END =====================================*/
